/*
 * MACRO to find polarized distribution of fluorophore tagged protein in two channels
 * Not-a-part of the macro: ROI of cells are detected either using automatic thresholding or manually and added to ROI manager and the ROIset is saved.   
 * Not-a-part of the macro: Create a binary mask of the image using suitable thresholding methods and a fluorescent channel whose signal can be used to determine the whole cell area.
 * Open the FLUORESCENCE IMAGES of cells in Fiji(ImageJ)
 * Rename one of the channels as "A" and the other channel as "B" (Assign "A" to the channel that shows the whole cell clearly). 
 * Open the binary mask of the image and rename it as "M".
 * if images do not have the pixel-to-micron scale set, using Set Scale, convert distance in pixels to microns in the image (and apply to Global if useful)
 * (This ensures that images from any microscope can use this macro to get comparable data)
 * Run the Macro.
 * Copy results from Log file, paste in an Spreadsheet, close Log file
 * MACRO ONLY WORKS FOR SINGLE IMAGES, NOT IMAGE STACK
*/


run("Options...", "iterations=1 count=1 black do=Nothing");

nROI=roiManager("count"); //find number of ROIs stored

Dialog.create("User Input");
Dialog.addCheckbox("Show masks", false);
Dialog.show();
chkbx1=Dialog.getCheckbox(); //to display mask images, i.e., not close them

run("Set Measurements...", "area mean centroid fit shape integrated redirect=None decimal=3");

selectWindow("A");  ns=nSlices; bd=bitDepth; getVoxelSize(widthPxl, heightPxl, depthPxl, unitPxl);

	
//MEASURE CENTROIDS AND SHAPE FACTORS FROM MASKS
//CREATE ARRAYS TO STORE SHAPE DETAILS
nROI=roiManager("count"); //find number of ROIs stored
Area=newArray(nROI); Xc=newArray(nROI); Yc=newArray(nROI); Circularity=newArray(nROI); Major=newArray(nROI); Minor=newArray(nROI); Angle=newArray(nROI);
FintA=newArray(nROI); BintA=newArray(nROI); FintB=newArray(nROI); BintB=newArray(nROI); FrameN=newArray(nROI);
//MEASURE AND STORE CELL SHAPE DETAILS IN THE ARRAYS
run("Clear Results");
for (j=0; j<nROI; j++)
{
	selectWindow("M"); roiManager("Select", j);
	run("Measure");
	Area[j]=parseFloat(getResultString("Area", j));
	Xc[j]=parseFloat(getResultString("X", j));
	Yc[j]=parseFloat(getResultString("Y", j));
	Circularity[j]=parseFloat(getResultString("Circ.", j));
	Major[j]=parseFloat(getResultString("Major", j));
	Minor[j]=parseFloat(getResultString("Minor", j));
	Angle[j]=parseFloat(getResultString("Angle", j));
}
	

for (j=0; j<nROI; j++)
{
	//BISECT CELL ROIs ALONG THE MINOR AXIS OF FITTED ELLIPSES
	phi=Angle[j]*PI/180;
	theta=phi+(PI/2);
	xbl1=(Xc[j]/widthPxl)+(Major[j]/2/widthPxl)*cos(theta); ybl1=(Yc[j]/heightPxl)-(Major[j]/2/heightPxl)*sin(theta); //draw minor axis but with length of major axis (center to one edge)
	xbl2=(Xc[j]/widthPxl)-(Major[j]/2/widthPxl)*cos(theta); ybl2=(Yc[j]/heightPxl)+(Major[j]/2/heightPxl)*sin(theta); //draw minor axis but with length of major axis (center to one edge)
	selectWindow("M"); setForegroundColor(0, 0, 0); setLineWidth(2); drawLine(xbl1, ybl1, xbl2, ybl2);
	
	//FIND COORDINATES OF THE CENTERS OF BOTH HALVES OF THE ELLIPSE
	xh1=(Xc[j]/widthPxl)+(Major[j]/8/widthPxl)*cos(phi);	yh1=(Yc[j]/heightPxl)-(Major[j]/8/heightPxl)*sin(phi); //point on one half of ellipse
	xh2=(Xc[j]/widthPxl)-(Major[j]/8/widthPxl)*cos(phi);	yh2=(Yc[j]/heightPxl)+(Major[j]/8/heightPxl)*sin(phi); //point on the other half

	//MEASURE TOTAL INTENSITY IN ONE HALF FOR BOTH A AND B IMAGES
	selectWindow("M"); run("Select None"); doWand(xh1, yh1); roiManager("add");
	selectWindow("A"); roiManager("Select", nROI); run("Measure");
	FintA[j]=parseFloat(getResultString("RawIntDen",nROI));
	Table.deleteRows(nROI, nROI);
	selectWindow("B"); roiManager("Select", nROI); run("Measure");
	FintB[j]=parseFloat(getResultString("RawIntDen",nROI));
	Table.deleteRows(nROI, nROI);
	roiManager("Select", nROI); roiManager("delete");
	
	//MEASURE TOTAL INTENSITY IN THE OTHER HALF FOR BOTH A AND B IMAGES
	selectWindow("M"); run("Select None");
	selectWindow("M"); doWand(xh2, yh2); roiManager("add");
	selectWindow("A"); roiManager("Select", nROI); run("Measure");
	BintA[j]=parseFloat(getResultString("RawIntDen",nROI));
	Table.deleteRows(nROI, nROI);
	selectWindow("B"); roiManager("Select", nROI); run("Measure");
	BintB[j]=parseFloat(getResultString("RawIntDen",nROI));
	Table.deleteRows(nROI, nROI);
	roiManager("Select", nROI); roiManager("delete");
}
setTool("rectangle");

//PRINT THE MEASURED VALUES TO LOG FILE
print("CellNumber"+"\t"+"Area_(um^2)"+"\t"+"Circularity"+"\t"+"Front_A"+"\t"+"Front_B"+"\t"+"Back_A"+"\t"+"Back_B"+"\t"+"F/B_A"+"\t"+"F/B_B");
for (j=0; j<=(nROI-1); j++)
{
	print(FrameN[j]+"\t"+Area[j]+"\t"+Circularity[j]+"\t"+FintA[j]+"\t"+FintB[j]+"\t"+BintA[j]+"\t"+BintB[j]+"\t"+(FintA[j]/BintA[j])+"\t"+(FintB[j]/BintB[j]));
}
roiManager("Deselect"); roiManager("Delete");
selectWindow("A"); close();
selectWindow("B"); close();
if (chkbx1==false) { selectWindow("M"); close(); }
if (chkbx1==true) { selectWindow("M"); }
//Enjoy!_P.B.